; Dll_test.asm - calls the functions in Dll.dll, created from Dll.asm
;
; To assemble this program, you'll need to have assembled Dll.asm, which
; produced Dll.lib. First, assemble this program in the usual way to
; generate an object file, and then link it via:
;
; link /entry:WinMain /subsystem:windows /libpath:<libpath> /defaultlib:Dll.lib dll_test.obj
;
; To summarise, the complete process for building both the dll and the
; executable to test the dll is:
;
; 1. Assemble Dll.asm
; 2. Link dll.obj with /entry:DllMain /dll /def:dll.def
; 3. Assemble Dll_test.asm
; 4. Link dll_test.obj with /defaultlib:dll.lib
; 5. Run dll_test.exe
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

;
; The two functions we want to call are defined in a file that is only
; added in at link-time, so we define them with EXTERN to tell NASM this
;
EXTERN _DllTest@0
EXTERN _DllTest2@8

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	;
	WinMainPrologue
	;
	; Here's where we call the functions in the DLL. To do this,
	; we use the sc macro, just as if we were calling an API
	; function. We can do this because the functions in our DLL
	; have been made GLOBAL (ie by procglobal) in exactly the
	; same way as the functions in the API are.
	;
	sc DllTest
	TEXTlocal _msgbox_title, 'DLL test',0
	TEXTlocal _msgbox_text, 'Hello from the DLL test program!',0
	sc DllTest2, ._msgbox_title, ._msgbox_text
	;
	; And that's it for calling functions in our DLL! Note how easy
	; Windows make it for parameter passing - memory addresses are
	; still the same in the DLL as they are in the main process as
	; Windows takes care of mapping the DLL into our memory space.
	; Pretty convenient eh?
	;
	xor	eax,eax
	WinMainEpilogue
endproc

[section .bss]

[section .data]
